var samplePageObj = {
  // 샘플 타이틀
  title: 'attribute 포뮬러',
  subtitle: '특정 기능(CanEdit,Color 등)에 대해 조건에 따른 포뮬러를 설정할 수 있습니다.',
  // 샘플 설명
  desc: 'attribute+formula를 사용시에는 반드시 <strong>(Row)CalcOrder</strong>에 \'컬럼명+기능명\'형식으로, 계산 순서에 맞게 명시해 줘야합니다.<br>'
    + 'formula의 계산식은 문자열이나 함수형태로 설정할수 있습니다.'
    + 'ClassFormula 를 사용하려는 경우, css class 를 미리 지정해 두어야 합니다. ',

  // 객체 초기화 구문
  init: {
    Def: {
      Row: {
        CanFormula: 1,
        CalcOrder: 'itemCanEdit,preWeek1TextColor,preYear1Color,preWeek2Color,preYear2Icon,preWeek3HtmlPrefix,preYear3Class'
      },
      Col: {
        Width: '130',
        CanEdit: 1,
        Format: '##0.00 \\%',
      }
    },
    Cfg: {
      SearchMode: 0,
      HeaderMerge: 4,
      DataMerge: 1,
      PrevColumnMerge: 1
    },
    Cols: [
      {
        Header: [
          '구분',
          '구분'
        ],
        Type: 'Text',
        Name: 'cmpny',
        Width: '100',
        Format: '',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: [
          '품목별',
          '품목별'
        ],
        Type: 'Text',
        Name: 'item',
        Width: '150',
        Format: '',
        CanEditFormula: itemFormula
      },
      {
        Header: [
          '2018.11',
          '전월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preWeek1',
        TextColorFormula: preWeek1Formula
      },
      {
        Header: [
          '2018.11',
          '전년동월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preYear1',
        ColorFormula: preYear1Formula
      },
      {
        Header: [
          '2018.10',
          '전월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preWeek2',
        ColorFormula: preWeek2Formula
      },
      {
        Header: [
          '2018.10',
          '전년동월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preYear2',
        IconFormula: 'Value<-3||Value===\'\'?\'../assets/imgs/Red.svg\':(Value>0?\'../assets/imgs/Green.svg\':\'../assets/imgs/Yellow.svg\')'
      },
      {
        Header: [
          '2018.09',
          '전월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preWeek3',
        RelWidth: 1,
        MinWidth: '180',
        Format: '##0.0',
        HtmlPrefixFormula: '\'<div style=width:\'+Math.abs(Value>10||Value<-10?80:Value*8)+\'%;overflow:hidden;float:left;background:\'+(Value>0?\'#44CCFF\':Value<0?\'#ff8888\':\'white\')+\';>&nbsp;</div>\''
      },
      {
        Header: [
          '2018.09',
          '전년동월대비 \n매출증감률(%)'
        ],
        Type: 'Float',
        Name: 'preYear3',
        ClassFormula: 'Value < -10 ? \'Red Fontsize20\' : \'Blue Italic\''
      },
    ],
  },
  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      preWeek1: '20.0 ',
      preYear1: '4.2 ',
      preWeek2: '7.0',
      preYear2: '2.5',
      preWeek3: '1.3',
      preYear3: '-4.2 ',
      cmpny: '백화점',
      item: '비식품소계'
    },
    {
      preWeek1: '18.2 ',
      preYear1: '-3.6',
      preWeek2: '-7.2 ',
      preYear2: '-9.0 ',
      preWeek3: '-0.8 ',
      preYear3: '-7.3 ',
      cmpny: '백화점',
      item: '잡화'
    },
    {
      preWeek1: '13.3 ',
      preYear1: '0.5 ',
      preWeek2: '22.3 ',
      preYear2: '7.9',
      preWeek3: '6.8',
      preYear3: '-3.6 ',
      cmpny: '백화점',
      item: '여성정장'
    },
    {
      preWeek1: '30.6 ',
      preYear1: '-1.7',
      preWeek2: '18.4 ',
      preYear2: '1.5',
      preWeek3: '7.3',
      preYear3: '-10.7',
      cmpny: '백화점',
      item: '여성캐주얼'
    },
    {
      preWeek1: '59.4 ',
      preYear1: '10.1',
      preWeek2: '18.3 ',
      preYear2: '0.5',
      preWeek3: '0.9',
      preYear3: '-6.5 ',
      cmpny: '백화점',
      item: '남성의류'
    },
    {
      preWeek1: '47.1 ',
      preYear1: '5.7 ',
      preWeek2: '15.1 ',
      preYear2: '2.4',
      preWeek3: '4.6',
      preYear3: '-13.2',
      cmpny: '백화점',
      item: '아동/스포츠 '
    },
    {
      preWeek1: '-1.4 ',
      preYear1: '9.3 ',
      preWeek2: '8.5',
      preYear2: '1.8',
      preWeek3: '-14.3',
      preYear3: '2.3',
      cmpny: '백화점',
      item: '가정용품'
    },
    {
      preWeek1: '10.9 ',
      preYear1: '10.3',
      preWeek2: '-4.6 ',
      preYear2: '12.1 ',
      preWeek3: '3.9',
      preYear3: '10.0 ',
      cmpny: '백화점',
      item: '해외유명브랜드'
    },
    {
      preWeek1: '41.9 ',
      preYear1: '6.7 ',
      preWeek2: '-39.9',
      preYear2: '-5.2 ',
      preWeek3: '1.3',
      preYear3: '0.1',
      cmpny: '백화점',
      item: '식품'
    },
    {
      preWeek1: '9.1',
      preYear1: '3.8 ',
      preWeek2: '-10.4',
      preYear2: '-18.3',
      preWeek3: '-0.5 ',
      preYear3: '-10.7',
      cmpny: '대형마트',
      item: '비식품소계'
    },
    {
      preWeek1: '-7.4 ',
      preYear1: '10.2',
      preWeek2: '-10.5',
      preYear2: '-18.9',
      preWeek3: '5.6',
      preYear3: '-5.1 ',
      cmpny: '대형마트',
      item: '가전문화'
    },
    {
      preWeek1: '51.8 ',
      preYear1: '8.3 ',
      preWeek2: '16.4 ',
      preYear2: '-10.0',
      preWeek3: '-5.1 ',
      preYear3: '-17.5',
      cmpny: '대형마트',
      item: '의류'
    },
    {
      preWeek1: '14.1 ',
      preYear1: '-0.4',
      preWeek2: '-18.6',
      preYear2: '-19.8',
      preWeek3: '-2.0 ',
      preYear3: '-8.5 ',
      cmpny: '대형마트',
      item: '가정생활'
    },
    {
      preWeek1: '-5.3 ',
      preYear1: '-0.9',
      preWeek2: '4.8',
      preYear2: '-19.9',
      preWeek3: '-12.2',
      preYear3: '-17.5',
      cmpny: '대형마트',
      item: '스포츠'
    },
    {
      preWeek1: '23.6 ',
      preYear1: '1.5 ',
      preWeek2: '-12.5',
      preYear2: '-19.5',
      preWeek3: '-0.4 ',
      preYear3: '-18.4',
      cmpny: '대형마트',
      item: '잡화'
    },
    {
      preWeek1: '12.2 ',
      preYear1: '10.6',
      preWeek2: '-27.9',
      preYear2: '-11.6',
      preWeek3: '-1.3 ',
      preYear3: '3.4',
      cmpny: '대형마트',
      item: '식품'
    },
    {
      preWeek1: '-2.3 ',
      preYear1: '3.2 ',
      preWeek2: '-0.8 ',
      preYear2: '5.0',
      preWeek3: '-4.6 ',
      preYear3: '4.2',
      cmpny: '편의점',
      item: '비식품소계'
    },
    {
      preWeek1: '6.7',
      preYear1: '12.8',
      preWeek2: '-1.3 ',
      preYear2: '2.0',
      preWeek3: '-9.3 ',
      preYear3: '5.0',
      cmpny: '편의점',
      item: '생활용품'
    },
    {
      preWeek1: '4.7',
      preYear1: '13.7',
      preWeek2: '-1.7 ',
      preYear2: '7.0',
      preWeek3: '-8.7 ',
      preYear3: '8.3',
      cmpny: '편의점',
      item: '잡화'
    },
    {
      preWeek1: '-3.3 ',
      preYear1: '2.0 ',
      preWeek2: '-0.7 ',
      preYear2: '5.2',
      preWeek3: '-4.1 ',
      preYear3: '4.0',
      cmpny: '편의점',
      item: '기타'
    },
    {
      preWeek1: '-0.5 ',
      preYear1: '6.7 ',
      preWeek2: '-8.0 ',
      preYear2: '4.4',
      preWeek3: '-10.7',
      preYear3: '8.6',
      cmpny: '편의점',
      item: '식품소계'
    },
    {
      preWeek1: '-1.4 ',
      preYear1: '6.6 ',
      preWeek2: '-10.1',
      preYear2: '1.9',
      preWeek3: '-11.6',
      preYear3: '7.8',
      cmpny: '편의점',
      item: '가공식품'
    },
    {
      preWeek1: '3.6',
      preYear1: '7.2 ',
      preWeek2: '0.8',
      preYear2: '14.5 ',
      preWeek3: '-6.9 ',
      preYear3: '11.6 ',
      cmpny: '편의점',
      item: '즉석·신선'
    },
    {
      preWeek1: '-0.8 ',
      preYear1: '4.7 ',
      preWeek2: '-12.5',
      preYear2: '2.5',
      preWeek3: '-4.6 ',
      preYear3: '-0.6 ',
      cmpny: 'SSM',
      item: '식품소계'
    },
    {
      preWeek1: '-0.1 ',
      preYear1: '7.6 ',
      preWeek2: '-14.9',
      preYear2: '4.0',
      preWeek3: '-2.8 ',
      preYear3: '2.0',
      cmpny: 'SSM',
      item: '농수축산'
    },
    {
      preWeek1: '-11.2',
      preYear1: '1.8 ',
      preWeek2: '-5.8 ',
      preYear2: '3.8',
      preWeek3: '-16.8',
      preYear3: '4.4',
      cmpny: 'SSM',
      item: '신선제품'
    },
    {
      preWeek1: '8.8',
      preYear1: '3.1 ',
      preWeek2: '-14.6',
      preYear2: '-0.9 ',
      preWeek3: '4.1',
      preYear3: '-7.1 ',
      cmpny: 'SSM',
      item: '가공,조리식품 '
    },
    {
      preWeek1: '6.7',
      preYear1: '-2.3',
      preWeek2: '-7.7 ',
      preYear2: '-9.9 ',
      preWeek3: '2.6',
      preYear3: '20.7 ',
      cmpny: 'SSM',
      item: '비식품소계'
    },
    {
      preWeek1: '7.5',
      preYear1: '-3.0',
      preWeek2: '-12.3',
      preYear2: '-11.5',
      preWeek3: '-3.4 ',
      preYear3: '15.5 ',
      cmpny: 'SSM',
      item: '일상용품'
    },
    {
      preWeek1: '5.1',
      preYear1: '-0.8',
      preWeek2: '1.6',
      preYear2: '-7.0 ',
      preWeek3: '13.0 ',
      preYear3: '29.4 ',
      cmpny: 'SSM',
      item: '생활잡화'
    },
  ]
};

function itemFormula(fr) { return fr.Row.cmpny == '백화점' ? 1 : 0; }

function preWeek1Formula(fr) {
  var color = '';

  if (fr.Value > 20) {
    color = '#0000FF';
  } else if (fr.Value < 0) {
    color = '#FF0000';
  }

  return color;
}

function preYear1Formula(fr) {
  var color = '';

  if (fr.Value > 0) {
    color = '#FC0';
  } else if (fr.Value < -3) {
    color = '#DFE';
  }

  return color;
}

function preWeek2Formula(fr) {
  var color = '';

  if (fr.Value < -5) {
    color = 'rgb(0,200,210)';
  } else if (fr.Value < 0) {
    color = 'rgb(100,200,0)';
  }

  return color;
}
